/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.type;

import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemCarryTempData;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public record CarriedItemTemperature(ItemRequirement item, List<Either<IntegerBounds, EquipmentSlot>> slots, double temperature, Temperature.Trait trait, double maxEffect, EntityRequirement entityRequirement) implements NbtSerializable
{
    public static CarriedItemTemperature createFromData(ItemCarryTempData data) {
        return new CarriedItemTemperature(data.data(), data.slots(), data.temp(), data.trait().orElse(Temperature.Trait.CORE), data.maxEffect().orElse((Double)Double.MAX_VALUE), data.entityRequirement().orElse(EntityRequirement.NONE));
    }

    public boolean testEntity(LivingEntity entity) {
        return this.entityRequirement.test((Entity)entity);
    }

    public boolean testSlot(ItemStack stack, @Nullable Integer slot, @Nullable EquipmentSlot equipmentSlot) {
        if (!this.item.test(stack, true)) {
            return false;
        }
        if (slot == null && equipmentSlot == null) {
            return false;
        }
        for (Either<IntegerBounds, EquipmentSlot> either : this.slots) {
            if (slot != null && either.left().isPresent() && ((IntegerBounds)either.left().get()).test(slot)) {
                return true;
            }
            if (equipmentSlot == null || !either.right().isPresent() || !((EquipmentSlot)either.right().get()).equals((Object)equipmentSlot)) continue;
            return true;
        }
        return false;
    }

    public String getSlotRangeName() {
        String[] strictType = new String[]{""};
        if (this.slots().size() == 1) {
            this.slots().get(0).ifLeft(left -> {
                if (left.equals(IntegerBounds.NONE)) {
                    strictType[0] = "inventory";
                }
                if (left.min() == 36 && left.max() == 44) {
                    strictType[0] = "hotbar";
                }
            });
        } else if (this.slots().size() == 2 && this.slots().get(0).right().map(right -> right == EquipmentSlot.MAINHAND).orElse(false).booleanValue() && this.slots().get(1).right().map(right -> right == EquipmentSlot.OFFHAND).orElse(false).booleanValue()) {
            strictType[0] = "hand";
        }
        return strictType[0];
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("item", (Tag)this.item.serialize());
        ListTag slotsTag = new ListTag();
        for (Either<IntegerBounds, EquipmentSlot> either : this.slots) {
            CompoundTag slotTag = new CompoundTag();
            if (either.left().isPresent()) {
                slotTag.m_128365_("bounds", (Tag)((IntegerBounds)either.left().get()).serialize());
            } else if (either.right().isPresent()) {
                slotTag.m_128359_("slot", ((EquipmentSlot)either.right().get()).m_20751_());
            }
            slotsTag.add((Object)slotTag);
        }
        tag.m_128365_("slots", (Tag)slotsTag);
        tag.m_128347_("temperature", this.temperature);
        tag.m_128359_("trait", this.trait.m_7912_());
        tag.m_128347_("maxEffect", this.maxEffect);
        tag.m_128365_("entity", (Tag)this.entityRequirement.serialize());
        return tag;
    }

    public static CarriedItemTemperature deserialize(CompoundTag tag) {
        ItemRequirement item = ItemRequirement.deserialize(tag.m_128469_("item"));
        ArrayList<Either<IntegerBounds, EquipmentSlot>> slots = new ArrayList<Either<IntegerBounds, EquipmentSlot>>();
        ListTag slotsTag = tag.m_128437_("slots", 10);
        for (int i = 0; i < slotsTag.size(); ++i) {
            CompoundTag slotTag = slotsTag.m_128728_(i);
            if (slotTag.m_128441_("bounds")) {
                slots.add(Either.left((Object)IntegerBounds.deserialize(slotTag.m_128469_("bounds"))));
                continue;
            }
            if (!slotTag.m_128441_("slot")) continue;
            slots.add(Either.right((Object)EquipmentSlot.m_20747_((String)slotTag.m_128461_("slot"))));
        }
        double temperature = tag.m_128459_("temperature");
        Temperature.Trait trait = Temperature.Trait.fromID(tag.m_128461_("trait"));
        double maxEffect = tag.m_128459_("maxEffect");
        EntityRequirement entityRequirement = EntityRequirement.deserialize(tag.m_128469_("entity"));
        return new CarriedItemTemperature(item, slots, temperature, trait, maxEffect, entityRequirement);
    }
}

